import java.io.IOException;

public class SavingsAccount extends Account {
	
	
	private int myTransactionLimit= 100;
	private double interestRate = .001;
	private int transcount = 0;
	
	/**Constructor: creates a savings account by calling super constructor **/
	public SavingsAccount(double startBalance, Bank bank, Person owner) {
		super(startBalance, bank, owner); 
		}
	
	/**Withdraws money from the account making sure that you are not over your transaction limit **/
	public void withdraw(double amt){
		try {
			if( getOwner().requestPassword()){
				if(transcount<myTransactionLimit){
					Transfer.transfer(this, getOwner(), amt);
				}
				else{
					System.out.println("You are over your transaction limit");
				}
				
				transcount++;
			}
		} catch (IOException e) {
			e.printStackTrace();
		}
	}


}
